<?php
// controllers/conductor_controller.php

if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) { header('Location: ../index.php?error=unauthorized'); exit; }

require_once '../config/db.php';

$accion = isset($_POST['accion']) ? $_POST['accion'] : '';
$conductor_id = isset($_POST['conductor_id']) ? (int)$_POST['conductor_id'] : 0;
$user_role = isset($_SESSION['user_role']) ? $_SESSION['user_role'] : 'usuario';

try {
    if ($_SERVER["REQUEST_METHOD"] == "POST") {

        // --- Obtener datos comunes ---
        $nombre = trim($_POST['nombre']);
        $apellido = trim($_POST['apellido']);
        $dni = trim($_POST['dni']);
        $direccion = trim($_POST['direccion'] ?? null);
        $provincia = trim($_POST['provincia'] ?? null);
        $distrito = trim($_POST['distrito'] ?? null);
        $telefono = trim($_POST['telefono'] ?? null);
        $licencia_conducir = trim($_POST['licencia_conducir'] ?? null); // NUEVO: Obtener licencia
        $dni_image_path = null; // Para agregar
        $nuevo_dni_image_path = null; // Para editar

        // --- ACCIÓN AGREGAR ---
        if ($accion === 'agregar') {
            // VALIDACIONES (¡MEJORAR!)
            if (empty($nombre) || empty($apellido) || empty($dni)) { throw new Exception("Nombre, Apellido y DNI son obligatorios."); }
            if (!preg_match('/^[0-9]{8}$/', $dni)) { throw new Exception("El DNI debe tener 8 dígitos numéricos."); }
            // Añadir validación para licencia si es necesario

             // --- Manejo Imagen ---
             if (isset($_FILES['dni_imagen']) && $_FILES['dni_imagen']['error'] == 0) { /* ... (código subida igual, usa dni_conductor) ... */
                 $target_dir = "../uploads/dni_conductor/"; if (!file_exists($target_dir)) { mkdir($target_dir, 0777, true); }
                 $imageFileType = strtolower(pathinfo($_FILES["dni_imagen"]["name"], PATHINFO_EXTENSION)); $new_filename = "dni_" . $dni . "_" . time() . "." . $imageFileType; $target_file = $target_dir . $new_filename;
                 if (move_uploaded_file($_FILES["dni_imagen"]["tmp_name"], $target_file)) { $dni_image_path = $new_filename; } else { throw new Exception("Hubo un error al subir la imagen del conductor."); }
            }
             // --- Fin Manejo Imagen ---

            // MODIFICADO: Añadir 'licencia_conducir' y placeholder '?'
            $sql = "INSERT INTO conductores (nombre, apellido, dni, direccion, provincia, distrito, telefono, licencia_conducir, dni_image_path) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt = $pdo->prepare($sql);
            // MODIFICADO: Añadir $licencia_conducir al array execute
            $stmt->execute([$nombre, $apellido, $dni, $direccion, $provincia, $distrito, $telefono, $licencia_conducir, $dni_image_path]);
            $_SESSION['form_success'] = "Conductor agregado exitosamente.";

        // --- ACCIÓN EDITAR ---
        } elseif ($accion === 'editar' && $conductor_id > 0) {
            // VALIDACIONES (¡MEJORAR!)
             if (empty($nombre) || empty($apellido) || empty($dni)) { throw new Exception("Nombre, Apellido y DNI son obligatorios."); }
             if (!preg_match('/^[0-9]{8}$/', $dni)) { throw new Exception("El DNI debe tener 8 dígitos numéricos."); }

             // --- Manejo Imagen Edición ---
             if (isset($_FILES['dni_imagen']) && $_FILES['dni_imagen']['error'] == 0) { /* ... (código subida igual, usa dni_conductor) ... */
                 $target_dir = "../uploads/dni_conductor/"; if (!file_exists($target_dir)) { mkdir($target_dir, 0777, true); }
                 $imageFileType = strtolower(pathinfo($_FILES["dni_imagen"]["name"], PATHINFO_EXTENSION)); $new_filename = "dni_" . $dni . "_" . time() . "." . $imageFileType; $target_file = $target_dir . $new_filename;
                 if (move_uploaded_file($_FILES["dni_imagen"]["tmp_name"], $target_file)) { $nuevo_dni_image_path = $new_filename; /* Opcional: borrar anterior */ } else { throw new Exception("Hubo un error al subir la nueva imagen del conductor."); }
            }
             // --- Fin Manejo Imagen Edición ---

            // MODIFICADO: Añadir 'licencia_conducir = ?'
            if ($nuevo_dni_image_path !== null) {
                $sql = "UPDATE conductores SET nombre = ?, apellido = ?, dni = ?, direccion = ?, provincia = ?, distrito = ?, telefono = ?, licencia_conducir = ?, dni_image_path = ? WHERE id = ?";
                $stmt = $pdo->prepare($sql);
                // MODIFICADO: Añadir $licencia_conducir al execute
                $stmt->execute([$nombre, $apellido, $dni, $direccion, $provincia, $distrito, $telefono, $licencia_conducir, $nuevo_dni_image_path, $conductor_id]);
            } else {
                $sql = "UPDATE conductores SET nombre = ?, apellido = ?, dni = ?, direccion = ?, provincia = ?, distrito = ?, telefono = ?, licencia_conducir = ? WHERE id = ?";
                $stmt = $pdo->prepare($sql);
                 // MODIFICADO: Añadir $licencia_conducir al execute
                $stmt->execute([$nombre, $apellido, $dni, $direccion, $provincia, $distrito, $telefono, $licencia_conducir, $conductor_id]);
            }
            $_SESSION['form_success'] = "Conductor actualizado exitosamente.";

        // --- ACCIÓN ELIMINAR ---
        } elseif ($accion === 'eliminar' && $conductor_id > 0) {
             if ($user_role !== 'administrador') { throw new Exception("No tienes permiso para realizar esta acción."); }
             // (Opcional: borrar imagen)
             $sql = "DELETE FROM conductores WHERE id = ?";
             $stmt = $pdo->prepare($sql);
             $stmt->execute([$conductor_id]);
             $_SESSION['form_success'] = "Conductor eliminado exitosamente.";

        } else {
            throw new Exception("Acción no válida o ID de conductor faltante.");
        }
    } else {
         throw new Exception("Método de solicitud no válido.");
    }

    header('Location: ../views/conductor.php');
    exit;

} catch (PDOException | Exception $e) {
    error_log("Error en conductor_controller: " . $e->getMessage());
     if ($e instanceof PDOException && $e->errorInfo[1] == 1062) { // Error DNI duplicado
         $_SESSION['form_error'] = "Error: El DNI '$dni' ya está registrado.";
    } else {
        $_SESSION['form_error'] = "Error: " . $e->getMessage();
    }
    header('Location: ../views/conductor.php');
    exit;
}
?>