<?php
// controllers/usuario_controller.php

if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) { header('Location: ../index.php?error=unauthorized'); exit; }

require_once '../config/db.php';

// --- Permisos y Datos ---
$user_role = isset($_SESSION['user_role']) ? $_SESSION['user_role'] : 'usuario';
$current_user_id = $_SESSION['user_id'];

// Solo admins pueden ejecutar acciones aquí
if ($user_role !== 'administrador') {
    $_SESSION['form_error'] = "Acción no autorizada.";
    header('Location: ../dashboard.php'); // O a donde sea apropiado
    exit;
}

$accion = isset($_POST['accion']) ? $_POST['accion'] : '';
$usuario_id = isset($_POST['usuario_id']) ? (int)$_POST['usuario_id'] : 0;

try {
    if ($_SERVER["REQUEST_METHOD"] == "POST") {

        // --- ACCIÓN AGREGAR ---
        if ($accion === 'agregar') {
            $username = trim($_POST['username']);
            $nombre_completo = trim($_POST['nombre_completo'] ?? null);
            $rol = trim($_POST['rol']);
            $password = $_POST['password'];
            $password_confirm = $_POST['password_confirm'];

            // VALIDACIONES (¡MEJORAR!)
            if (empty($username) || empty($rol) || empty($password) || empty($password_confirm)) { throw new Exception("Usuario, Rol y Contraseñas son obligatorios para agregar."); }
            if ($password !== $password_confirm) { throw new Exception("Las contraseñas no coinciden."); }
            if (strlen($password) < 6) { throw new Exception("La contraseña debe tener al menos 6 caracteres."); } // Ejemplo validación longitud
            if (!in_array($rol, ['administrador', 'usuario'])) { throw new Exception("Rol no válido."); }

            // Verificar si username ya existe
            $stmtCheck = $pdo->prepare("SELECT id FROM usuarios WHERE username = ?");
            $stmtCheck->execute([$username]);
            if ($stmtCheck->fetch()) { throw new Exception("El nombre de usuario '$username' ya está en uso."); }

            // Hashear contraseña
            $password_hash = password_hash($password, PASSWORD_DEFAULT);

            $sql = "INSERT INTO usuarios (username, nombre_completo, rol, password_hash, activo) VALUES (?, ?, ?, ?, 1)"; // Por defecto activo
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$username, $nombre_completo, $rol, $password_hash]);
            $_SESSION['form_success'] = "Usuario agregado exitosamente.";

        // --- ACCIÓN EDITAR ---
        } elseif ($accion === 'editar' && $usuario_id > 0) {
            // $username = trim($_POST['username']); // No se permite cambiar username en esta implementación
            $nombre_completo = trim($_POST['nombre_completo'] ?? null);
            $rol = trim($_POST['rol']);
            $password = $_POST['password'];
            $password_confirm = $_POST['password_confirm'];

            // Validaciones
            if (empty($rol)) { throw new Exception("El rol es obligatorio."); }
            if (!in_array($rol, ['administrador', 'usuario'])) { throw new Exception("Rol no válido."); }

            // Construcción dinámica del UPDATE
            $fieldsToUpdate = ['nombre_completo = ?', 'rol = ?'];
            $params = [$nombre_completo, $rol];

            // Si se proporcionó contraseña nueva, validarla y añadirla
            if (!empty($password)) {
                 if ($password !== $password_confirm) { throw new Exception("Las contraseñas no coinciden."); }
                 if (strlen($password) < 6) { throw new Exception("La contraseña debe tener al menos 6 caracteres."); }
                 $password_hash = password_hash($password, PASSWORD_DEFAULT);
                 $fieldsToUpdate[] = 'password_hash = ?';
                 $params[] = $password_hash;
            }

            $params[] = $usuario_id; // Añadir ID al final para el WHERE

            $sql = "UPDATE usuarios SET " . implode(', ', $fieldsToUpdate) . " WHERE id = ?";
            $stmt = $pdo->prepare($sql);
            $stmt->execute($params);
            $_SESSION['form_success'] = "Usuario actualizado exitosamente.";

        // --- ACCIÓN TOGGLE ESTADO ---
        } elseif ($accion === 'toggle_status' && $usuario_id > 0) {
            if ($usuario_id === $current_user_id) { throw new Exception("No puedes cambiar tu propio estado."); }
            // Podrías añadir lógica para no desactivar al último admin
            $sql = "UPDATE usuarios SET activo = NOT activo WHERE id = ?";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$usuario_id]);
             // Obtener el nuevo estado para el mensaje
             $stmtStatus = $pdo->prepare("SELECT activo FROM usuarios WHERE id = ?");
             $stmtStatus->execute([$usuario_id]);
             $nuevoEstado = $stmtStatus->fetchColumn();
             $mensajeEstado = $nuevoEstado ? 'activado' : 'desactivado';

            $_SESSION['form_success'] = "Usuario $mensajeEstado exitosamente.";


        // --- ACCIÓN ELIMINAR ---
        } elseif ($accion === 'eliminar' && $usuario_id > 0) {
             if ($usuario_id === $current_user_id) { throw new Exception("No puedes eliminarte a ti mismo."); }
             // Podrías añadir lógica para no eliminar al último admin
             $sql = "DELETE FROM usuarios WHERE id = ?";
             $stmt = $pdo->prepare($sql);
             $stmt->execute([$usuario_id]);
             $_SESSION['form_success'] = "Usuario eliminado exitosamente.";

        } else {
            throw new Exception("Acción no válida o ID de usuario faltante.");
        }
    } else {
         throw new Exception("Método de solicitud no válido.");
    }

    header('Location: ../views/usuarios.php');
    exit;

} catch (PDOException | Exception $e) {
    error_log("Error en usuario_controller: " . $e->getMessage());
    if ($e instanceof PDOException && $e->errorInfo[1] == 1062) { // Error de duplicado (username)
         $_SESSION['form_error'] = "Error: El nombre de usuario ya existe.";
    } else {
        $_SESSION['form_error'] = "Error: " . $e->getMessage();
    }
    header('Location: ../views/usuarios.php');
    exit;
}
?>