<?php
// controllers/vehiculo_controller.php

if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) { header('Location: ../index.php?error=unauthorized'); exit; }

require_once '../config/db.php';

$accion = isset($_POST['accion']) ? $_POST['accion'] : '';
$vehiculo_id = isset($_POST['vehiculo_id']) ? (int)$_POST['vehiculo_id'] : 0;
$user_role = isset($_SESSION['user_role']) ? $_SESSION['user_role'] : 'usuario';

try {
    if ($_SERVER["REQUEST_METHOD"] == "POST") {

        // --- Obtener datos comunes (incluyendo el nuevo campo tablero) ---
        $placa = strtoupper(trim($_POST['placa'])); // Placa en mayúsculas
        $color = trim($_POST['color'] ?? null);
        $marca = trim($_POST['marca'] ?? null);
        $modelo = trim($_POST['modelo'] ?? null);
        $anio_modelo = !empty($_POST['anio_modelo']) ? (int)$_POST['anio_modelo'] : null;
        $tablero = trim($_POST['tablero'] ?? null); // <<<--- NUEVO: Obtener tablero
        $anotacion1 = trim($_POST['anotacion1'] ?? null);
        $anotacion2 = trim($_POST['anotacion2'] ?? null);
        $propietario_id = isset($_POST['propietario_id']) ? (int)$_POST['propietario_id'] : 0;
        $conductor_id = !empty($_POST['conductor_id']) ? (int)$_POST['conductor_id'] : null; // Permite NULL

        // --- Validaciones Básicas (¡MEJORAR!) ---
        if (empty($placa)) { throw new Exception("El número de placa es obligatorio."); }
        if ($propietario_id <= 0) { throw new Exception("Debe seleccionar un propietario válido."); }
        if ($anio_modelo !== null && ($anio_modelo < 1900 || $anio_modelo > (date('Y') + 1))) { throw new Exception("Año del modelo no válido."); }
        // Añadir validación de formato de placa si es necesario
        // Añadir validación para longitud de tablero si es necesario

        // --- ACCIÓN AGREGAR ---
        if ($accion === 'agregar') {
            // Verificar si placa ya existe
            $stmtCheck = $pdo->prepare("SELECT id FROM vehiculos WHERE placa = ?");
            $stmtCheck->execute([$placa]);
            if ($stmtCheck->fetch()) {
                throw new Exception("La placa '$placa' ya está registrada.");
            }

            // SQL INSERT: Añadir 'tablero' y su placeholder '?'
            $sql = "INSERT INTO vehiculos (placa, color, marca, modelo, anio_modelo, tablero, anotacion1, anotacion2, propietario_id, conductor_id)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"; // Se añadió un '?'
            $stmt = $pdo->prepare($sql);
            // Ejecutar: Añadir $tablero al array de parámetros
            $stmt->execute([$placa, $color, $marca, $modelo, $anio_modelo, $tablero, $anotacion1, $anotacion2, $propietario_id, $conductor_id]);
            $_SESSION['form_success'] = "Vehículo agregado exitosamente.";

        // --- ACCIÓN EDITAR ---
        } elseif ($accion === 'editar' && $vehiculo_id > 0) {
            // Verificar si la placa (si cambió) ya existe en OTRO vehículo
             $stmtCheck = $pdo->prepare("SELECT id FROM vehiculos WHERE placa = ? AND id != ?");
             $stmtCheck->execute([$placa, $vehiculo_id]);
             if ($stmtCheck->fetch()) {
                 throw new Exception("La placa '$placa' ya está registrada en otro vehículo.");
             }

            // SQL UPDATE: Añadir 'tablero = ?'
            $sql = "UPDATE vehiculos SET
                        placa = ?, color = ?, marca = ?, modelo = ?, anio_modelo = ?, tablero = ?,
                        anotacion1 = ?, anotacion2 = ?, propietario_id = ?, conductor_id = ?
                    WHERE id = ?"; // Se añadió 'tablero = ?'
            $stmt = $pdo->prepare($sql);
            // Ejecutar: Añadir $tablero al array de parámetros
            $stmt->execute([
                $placa, $color, $marca, $modelo, $anio_modelo, $tablero,
                $anotacion1, $anotacion2, $propietario_id, $conductor_id,
                $vehiculo_id
            ]);
            $_SESSION['form_success'] = "Vehículo actualizado exitosamente.";

        // --- ACCIÓN ELIMINAR ---
        } elseif ($accion === 'eliminar' && $vehiculo_id > 0) {
            if ($user_role !== 'administrador') { throw new Exception("No tienes permiso para eliminar vehículos."); }
            $sql = "DELETE FROM vehiculos WHERE id = ?";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$vehiculo_id]);
            $_SESSION['form_success'] = "Vehículo eliminado exitosamente.";

        } else {
            throw new Exception("Acción no válida o ID de vehículo faltante.");
        }
    } else {
         throw new Exception("Método de solicitud no válido.");
    }

    // Redirigir siempre a la vista de vehículos después de una acción
    header('Location: ../views/vehiculo.php');
    exit;

} catch (PDOException | Exception $e) {
    error_log("Error en vehiculo_controller: " . $e->getMessage());
    // Capturar error de placa duplicada (código SQL 23000, error 1062)
    if ($e instanceof PDOException && $e->errorInfo[1] == 1062) {
         $_SESSION['form_error'] = "Error: La placa '$placa' ya existe.";
    } else {
        // Capturar otros errores genéricos o específicos
        $_SESSION['form_error'] = "Error: " . $e->getMessage();
    }
    // Redirigir a la vista de vehículos incluso si hay error, para mostrar el mensaje
    header('Location: ../views/vehiculo.php');
    exit;
}
?>