<?php
// Iniciar sesión al principio
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - SysVehiculos</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    
    <link rel="shortcut icon" href="img/favicon.ico" type="image/x-icon">
    <link rel="icon" href="img/favicon.ico" type="image/x-icon">
   
    <!-- Estilos Personalizados (Asegúrate que es el CSS Correcto/Actualizado) -->
    <link rel="stylesheet" href="css/style.css">

</head>
<!-- Body usa Flexbox para centrar el login-box -->
<body class="login-page-body d-flex align-items-center justify-content-center min-vh-100">

    <!-- El Contenedor Principal Centrado (como la card de Sistema Votos) -->
    <div class="login-box shadow rounded overflow-hidden d-flex flex-column flex-md-row">

        <!-- Columna Izquierda (Imagen) -->
        <div class="login-box-image col-md-6 d-none d-md-block p-0">
            <img src="img/vehiculos-bg.jpg" alt="1" class="login-img">
            <!-- Asegúrate que la imagen img/vehiculos-bg.jpg exista -->
        </div>

        <!-- Columna Derecha (Formulario) -->
        <div class="login-box-form col-12 col-md-6 p-4 p-lg-5 d-flex flex-column justify-content-center">

            <!-- Título y Subtítulo -->
            <div class="text-center mb-4">
                <!-- Icono Opcional como en el ejemplo -->
                <!-- <div class="mb-2">
                    <i class="fas fa-clipboard-check fa-2x text-primary"></i>
                </div> -->
                <h1 class="fw-bold app-title mb-1">SysVehiculos</h1>
                <p class="welcome-text text-muted">Iniciar Sesión</p>
            </div>

            <?php
            // Mostrar mensaje de error si existe
            if (isset($_SESSION['login_error'])) {
                echo '<div class="alert alert-danger alert-dismissible fade show small py-2 mb-3" role="alert">';
                echo htmlspecialchars($_SESSION['login_error']);
                echo '<button type="button" class="btn-close btn-sm py-1" data-bs-dismiss="alert" aria-label="Close"></button>';
                echo '</div>';
                unset($_SESSION['login_error']);
            }
            ?>

            <!-- Formulario -->
            <form action="procesar_login.php" method="POST" class="mb-3">
                <div class="mb-3 form-floating">
                    <input type="text" class="form-control login-input" id="username" name="username" placeholder="Usuario o Email" required>
                    <label for="username"><i class="fas fa-user me-2"></i>Usuario o Email</label>
                </div>
                <div class="mb-3 form-floating">
                    <input type="password" class="form-control login-input" id="password" name="password" placeholder="Contraseña" required>
                    <label for="password"><i class="fas fa-lock me-2"></i>Contraseña</label>
                </div>

                <div class="d-flex justify-content-between align-items-center mb-4 small">
                    <div class="form-check">
                        <input type="checkbox" class="form-check-input" id="rememberMe" name="rememberMe">
                        <label class="form-check-label" for="rememberMe">Recordarme</label>
                    </div>
                    <a href="#" class="text-decoration-none forgot-password">¿Olvidaste?</a>
                </div>

                <button type="submit" class="btn btn-primary w-100 btn-lg login-button">
                    <i class="fas fa-sign-in-alt me-2"></i>Ingresar
                </button>
            </form>

            <hr class="my-3">

            <!-- Iconos Sociales -->
            <p class="text-center social-text small mb-3 text-muted">O contáctanos en:</p>
            <div class="social-icons text-center mb-4">
                 <a href="https://www.facebook.com/Fenialca" target="_blank" class="social-icon facebook mx-2" title="Facebook">
                    <i class="fab fa-facebook-f"></i>
                </a>
                <a href="https://wa.me/51903217132" target="_blank" class="social-icon whatsapp mx-2" title="WhatsApp">
                    <i class="fab fa-whatsapp"></i>
                </a>
                <a href="https://www.facebook.com/Fenialca" target="_blank" class="social-icon instagram mx-2" title="Instagram">
                    <i class="fab fa-instagram"></i>
                </a>
            </div>

            <!-- Botón para cambiar tema -->
            <div class="text-center">
                 <button class="btn btn-sm theme-toggle-btn">
                    <i class="fas fa-moon"></i> Cambiar Tema
                </button>
            </div>

        </div> <!-- Fin login-box-form -->

    </div> <!-- Fin login-box -->

    <!-- Scripts JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-C6RzsynM9kWDrMNeT87bh95OGNyZPhcTNXj1NW7RuBCsyN/o0jlpcV8Qyq46cDfL" crossorigin="anonymous"></script>
    <!-- Script Personalizado (Asegúrate que es el JS actualizado) -->
    <script src="js/script.js"></script>
</body>
</html>