// Espera a que el DOM esté completamente cargado
document.addEventListener('DOMContentLoaded', function() {

    // === LÓGICA DEL TEMA OSCURO (Revisada) ===
    // Selecciona TODOS los botones que puedan cambiar el tema
    const themeToggleBtns = document.querySelectorAll('.theme-toggle-btn, .theme-toggle-btn-nav');
    const body = document.body;

    // Función para aplicar el tema y actualizar iconos/texto de TODOS los botones encontrados
    const applyTheme = (theme) => {
        const isDark = theme === 'dark';
        // Aplicar/quitar la clase principal al body
        body.classList.toggle('dark-mode', isDark);

        // Actualizar cada botón encontrado
        themeToggleBtns.forEach(btn => {
            const icon = btn.querySelector('i');
            const textSpan = btn.querySelector('span'); // Solo existe en el botón del nav

            // Actualizar icono
            if (icon) {
                icon.classList.toggle('fa-sun', isDark);
                icon.classList.toggle('fa-moon', !isDark);
            }

            // Actualizar texto (si aplica)
            if (textSpan) { // Botón del Navbar
                textSpan.textContent = isDark ? ' Tema Claro' : ' Tema Oscuro';
            } else if (btn.classList.contains('theme-toggle-btn')) { // Botón del Login (sin span)
                 // Acceder al nodo de texto directamente (más robusto que childNodes[1])
                 let textNode = Array.from(btn.childNodes).find(node => node.nodeType === Node.TEXT_NODE && node.textContent.trim().length > 0);
                 if (textNode) {
                    textNode.nodeValue = isDark ? ' Cambiar Tema Claro' : ' Cambiar Tema Oscuro';
                 }
            }
        });
    };

    // Cargar el tema guardado en localStorage al iniciar
    const savedTheme = localStorage.getItem('theme') || 'light'; // Default a 'light'
    applyTheme(savedTheme); // Aplica el tema al cargar

    // Event listener para TODOS los botones de cambio de tema
    themeToggleBtns.forEach(btn => {
        btn.addEventListener('click', () => {
            // Determina cuál debería ser el nuevo tema
            const currentTheme = body.classList.contains('dark-mode') ? 'dark' : 'light';
            const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
            // Aplica el nuevo tema
            applyTheme(newTheme);
            // Guarda la preferencia en localStorage
            localStorage.setItem('theme', newTheme);
        });
    });


    // === LÓGICA DEL DASHBOARD ===

    // --- Toggle Sidebar ---
    const sidebarToggle = document.getElementById('sidebarToggle');
    const wrapper = document.getElementById('wrapper');

    if (sidebarToggle && wrapper) {
        // Estado inicial de la sidebar basado en localStorage
        if (localStorage.getItem('sidebarToggled') === 'true') {
            wrapper.classList.add('toggled');
        }

        sidebarToggle.addEventListener('click', function(event) {
            event.preventDefault();
            wrapper.classList.toggle('toggled');
            // Guardar estado de la sidebar en localStorage
            localStorage.setItem('sidebarToggled', wrapper.classList.contains('toggled'));
        });
    }

    // --- Activar link de sidebar según la página actual ---
    if (document.getElementById('sidebar-wrapper')) { // Solo ejecuta si existe la sidebar
        // Obtiene el nombre del archivo PHP actual de la URL
        const currentFullUrl = window.location.pathname;
        const currentPath = currentFullUrl.substring(currentFullUrl.lastIndexOf('/') + 1);
        // Considerar 'dashboard.php' como la página activa si no hay nombre de archivo (ej: /SysVehiculos/)
        // O si explícitamente es dashboard.php
        const isDashboard = currentPath === '' || currentPath === 'dashboard.php' || currentPath === 'index.php'; // Asumiendo que la raíz te lleva al dashboard o al login que redirige al dashboard

        const sidebarLinks = document.querySelectorAll('#sidebar-wrapper .list-group-item');

        sidebarLinks.forEach(link => {
            const linkHref = link.getAttribute('href');
            if (!linkHref || linkHref === '#') return; // Saltar si no es un enlace válido

            const linkPath = linkHref.substring(linkHref.lastIndexOf('/') + 1); // Obtener nombre del archivo del enlace
            const isDashboardLink = linkPath === 'dashboard.php';

            link.classList.remove('active'); // Limpiar todos
            link.removeAttribute('aria-current');

            // Activar si el nombre del archivo del enlace coincide con el actual
            // O si estamos en el dashboard y el enlace es al dashboard
            if (currentPath === linkPath || (isDashboard && isDashboardLink)) {
                link.classList.add('active');
                link.setAttribute('aria-current', 'true');
            }
        });
    }

}); // Fin del DOMContentLoaded