<?php
// 1. Iniciar sesión y verificar login (AL PRINCIPIO DE TODO)
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: ../index.php?error=not_logged_in'); // Correcto: Salir de views a index.php
    exit;
}

// 2. Incluir archivo de conexión a la BD (Verificar ruta)
// Esto debe definir la variable $pdo
require_once '../config/db.php'; // Correcto: Salir de views a config/

// --- Lógica de Roles (Definir ANTES de incluir sidebar) ---
$user_role = isset($_SESSION['user_role']) ? $_SESSION['user_role'] : 'usuario';
$current_user_id = $_SESSION['user_id']; // ID del usuario logueado (útil)
// $user_role = 'administrador'; // Descomentar solo para probar la vista de admin
// -----------------------------------------------------------

// 3. Obtener conductores (Incluyendo telefono y licencia_conducir)
$conductores = [];
$error_db = null;
try {
    // Asegurarse que $pdo está definido por db.php
    if (!isset($pdo)) {
         throw new Exception("Error: La conexión a la base de datos (PDO) no está definida. Revisa 'config/db.php'.");
    }
    // MODIFICADO: Añadir 'licencia_conducir' al SELECT
    $stmt = $pdo->query("SELECT id, nombre, apellido, dni, direccion, provincia, distrito, telefono, licencia_conducir FROM conductores ORDER BY apellido, nombre");
    $conductores = $stmt->fetchAll();
} catch (PDOException $e) {
    error_log("Error PDO al obtener conductores: " . $e->getMessage());
    $error_db = "No se pudieron cargar los conductores (Error DB: " . $e->getCode() . ")";
} catch (Exception $e) { // Capturar otros errores
    error_log("Error general al obtener conductores: " . $e->getMessage());
    $error_db = $e->getMessage();
}

// 4. Preparar datos del usuario logueado para la navbar
$username = isset($_SESSION['username']) ? htmlspecialchars($_SESSION['username']) : 'Usuario';

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Conductores - SysVehiculos</title>
    <!-- Favicon principal para la mayoría de navegadores -->
    <link rel="icon" href="img/favicon.ico" sizes="any"> <!-- Busca .ico en la raíz -->
    <!-- Alternativa SVG (si tienes uno) -->
    <!-- <link rel="icon" href="/img/logo.svg" type="image/svg+xml"> -->
    <!-- Icono para dispositivos Apple (180x180 recomendado) -->
    <link rel="apple-touch-icon" href="/img/apple-touch-icon.png"> <!-- Asume que está en /img/ -->
    <!-- Opcional: Manifiesto para PWA/Android -->
    <!-- <link rel="manifest" href="/manifest.webmanifest"> -->
    <!-- CSS y Font Awesome -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <!-- Ruta CSS corregida -->
    <link rel="stylesheet" href="../css/style.css">
    
    <!-- === FAVICON === -->
    <!-- Ruta relativa desde la raíz a la carpeta img/ -->
    <link rel="icon" href="img/favicon.ico" type="image/x-icon">
    <link rel="shortcut icon" href="img/favicon.ico" type="image/x-icon">
    <!-- Opcional: Si tienes un apple-touch-icon.png en /img/ -->
    <!-- <link rel="apple-touch-icon" href="img/apple-touch-icon.png"> -->
    <!-- ============= -->
     
    <style>
        /* Estilos específicos (igual que propietarios) */
        .img-preview { max-height: 150px; margin-top: 10px; display: none; }
        #noResultsConductorRow td { font-style: italic; color: var(--secondary-color); } /* ID específico */
         body.dark-mode #noResultsConductorRow td { color: var(--text-muted-dark); }
        /* Estilos AJAX search results */
        .search-results { position: absolute; background-color: var(--panel-bg-light); border: 1px solid var(--border-color-light); border-top: none; max-height: 200px; overflow-y: auto; width: calc(100% - 2px); z-index: 1050; display: none; border-radius: 0 0 0.375rem 0.375rem; box-shadow: var(--shadow-light); margin-top: -1px; }
         body.dark-mode .search-results { background-color: var(--panel-bg-dark); border-color: var(--border-color-dark); }
        .search-results .list-group-item { cursor: pointer; padding: 0.5rem 1rem; font-size: 0.9rem; background-color: transparent !important; color: var(--text-light); }
         body.dark-mode .search-results .list-group-item { color: var(--text-dark); border-bottom: 1px solid var(--border-color-dark) !important; }
         .search-results .list-group-item:last-child { border-bottom: none !important; }
        .search-results .list-group-item:hover { background-color: rgba(0, 0, 0, 0.05) !important; }
         body.dark-mode .search-results .list-group-item:hover { background-color: rgba(255, 255, 255, 0.07) !important; }
        .search-results .result-details { font-size: 0.8rem; color: var(--secondary-color); }
         body.dark-mode .search-results .result-details { color: var(--text-muted-dark); }
         .position-relative { position: relative; }
    </style>
</head>
<body class="dashboard-page">

    <div class="d-flex" id="wrapper">

        <!-- Sidebar (Incluida) -->
        <?php require_once '../includes/sidebar.php'; ?>

        <!-- Page Content -->
        <div id="page-content-wrapper">
            <nav class="navbar navbar-expand-lg navbar-light bg-light border-bottom">
                 <!-- ... (contenido navbar sin cambios) ... -->
                  <div class="container-fluid">
                    <button class="btn btn-primary btn-sm" id="sidebarToggle"><i class="fas fa-align-left"></i></button>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent"> <span class="navbar-toggler-icon"></span> </button>
                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav ms-auto mt-2 mt-lg-0">
                            <li class="nav-item me-2"> <button class="btn btn-sm theme-toggle-btn-nav"> <i class="fas fa-moon"></i> <span class="d-none d-sm-inline">Tema</span> </button> </li>
                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle" id="navbarDropdown" href="#" role="button" data-bs-toggle="dropdown"> <i class="fas fa-user me-1"></i> <?php echo $username; ?> </a>
                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                                    <a class="dropdown-item" href="#!">Mi Perfil</a> <a class="dropdown-item" href="#!">Configuración</a>
                                    <div class="dropdown-divider"></div> <a class="dropdown-item text-danger" href="../logout.php">Cerrar Sesión</a> <!-- Ruta verificada -->
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </nav>

            <!-- Contenido Principal de Conductores -->
            <div class="container-fluid px-4">
                <h1 class="mt-4">Gestión de Conductores</h1>
                <p>Administra los conductores registrados en el sistema.</p>

                 <div class="d-flex justify-content-between align-items-center mb-3">
                    <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#modalConductor" id="btnAgregarConductor"> <i class="fas fa-plus me-1"></i> Agregar Conductor </button>
                 </div>

                 <!-- Buscador con Botón -->
                 <div class="row mb-3">
                    <div class="col-md-6">
                        <div class="input-group">
                            <input type="search" id="searchConductorInput" class="form-control" placeholder="Buscar por Nombre, Apellido o DNI..." aria-label="Buscar Conductor">
                            <button class="btn btn-outline-secondary" type="button" id="searchConductorButton"> <i class="fas fa-search"></i> Buscar </button>
                        </div>
                    </div>
                 </div>

                 <!-- Mensajes -->
                 <?php if ($error_db): ?><div class="alert alert-danger"><?php echo htmlspecialchars($error_db); ?></div><?php endif; ?>
                 <?php if (isset($_SESSION['form_success'])): ?><div class="alert alert-success alert-dismissible fade show" role="alert"><?php echo htmlspecialchars($_SESSION['form_success']); ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div><?php unset($_SESSION['form_success']); ?><?php endif; ?>
                 <?php if (isset($_SESSION['form_error'])): ?><div class="alert alert-danger alert-dismissible fade show" role="alert"><?php echo htmlspecialchars($_SESSION['form_error']); ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div><?php unset($_SESSION['form_error']); ?><?php endif; ?>

                 <!-- Tabla de Conductores -->
                 <div class="card mb-4">
                    <div class="card-header"> <i class="fas fa-table me-1"></i> Listado de Conductores </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover table-bordered" id="tablaConductores">
                                <thead class="table-dark">
                                    <tr>
                                        <th>#</th> <th>Nombre</th> <th>Apellido</th> <th>DNI</th> <th>Dirección</th>
                                        <th>Provincia</th> <th>Distrito</th> <th>Teléfono</th> <th>Licencia</th> <!-- Columna añadida -->
                                        <th>Acciones</th>
                                    </tr>
                                </thead>
                                <tbody id="tablaConductoresBody">
                                    <?php if (!$error_db && empty($conductores)): ?>
                                        <tr id="noDataConductorRow"> <td colspan="10" class="text-center">No hay conductores registrados.</td> </tr> <!-- Colspan +1 -->
                                    <?php elseif (!$error_db): ?>
                                        <?php $countCond = 1; ?>
                                        <?php foreach ($conductores as $cond): ?>
                                            <tr>
                                                <td><?php echo $countCond++; ?></td>
                                                <td><?php echo htmlspecialchars($cond['nombre']); ?></td>
                                                <td><?php echo htmlspecialchars($cond['apellido']); ?></td>
                                                <td><?php echo htmlspecialchars($cond['dni']); ?></td>
                                                <td><?php echo htmlspecialchars($cond['direccion'] ?? '-'); ?></td>
                                                <td><?php echo htmlspecialchars($cond['provincia'] ?? '-'); ?></td>
                                                <td><?php echo htmlspecialchars($cond['distrito'] ?? '-'); ?></td>
                                                <td><?php echo htmlspecialchars($cond['telefono'] ?? '-'); ?></td>
                                                <td><?php echo htmlspecialchars($cond['licencia_conducir'] ?? '-'); ?></td> <!-- Celda añadida -->
                                                <td>
                                                    <button type="button" class="btn btn-sm btn-warning btnEditarConductor"
                                                            data-bs-toggle="modal" data-bs-target="#modalConductor"
                                                            data-id="<?php echo $cond['id']; ?>"
                                                            data-nombre="<?php echo htmlspecialchars($cond['nombre']); ?>"
                                                            data-apellido="<?php echo htmlspecialchars($cond['apellido']); ?>"
                                                            data-dni="<?php echo htmlspecialchars($cond['dni']); ?>"
                                                            data-direccion="<?php echo htmlspecialchars($cond['direccion'] ?? ''); ?>"
                                                            data-provincia="<?php echo htmlspecialchars($cond['provincia'] ?? ''); ?>"
                                                            data-distrito="<?php echo htmlspecialchars($cond['distrito'] ?? ''); ?>"
                                                            data-telefono="<?php echo htmlspecialchars($cond['telefono'] ?? ''); ?>"
                                                            data-licencia="<?php echo htmlspecialchars($cond['licencia_conducir'] ?? ''); ?>" /* Data attribute añadido */
                                                            title="Editar Conductor"> <i class="fas fa-edit"></i> </button>
                                                    <?php if ($user_role === 'administrador'): ?>
                                                        <button type="button" class="btn btn-sm btn-danger btnEliminarConductor"
                                                                data-id="<?php echo $cond['id']; ?>"
                                                                data-nombre="<?php echo htmlspecialchars($cond['nombre'] . ' ' . $cond['apellido']); ?>"
                                                                title="Eliminar Conductor"> <i class="fas fa-trash-alt"></i> </button>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                    <tr id="noResultsConductorRow" style="display: none;"> <td colspan="10" class="text-center text-muted">No se encontraron conductores para su búsqueda.</td> </tr> <!-- Colspan +1 -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div> <!-- /container-fluid -->
        </div> <!-- /#page-content-wrapper -->
    </div> <!-- /#wrapper -->

    <!-- Modal para Agregar/Editar Conductor -->
    <div class="modal fade" id="modalConductor" tabindex="-1" aria-labelledby="modalConductorLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalConductorLabel">Agregar Conductor</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                     <!-- Ruta action verificada -->
                    <form id="formConductor" method="POST" action="../controllers/conductor_controller.php" enctype="multipart/form-data">
                        <input type="hidden" name="conductor_id" id="conductor_id" value="0">
                        <input type="hidden" name="accion" id="accionConductor" value="agregar">

                        <div class="row">
                            <div class="col-md-6 mb-3"> <label for="nombreConductor" class="form-label">Nombre <span class="text-danger">*</span></label> <input type="text" class="form-control" id="nombreConductor" name="nombre" required> </div>
                            <div class="col-md-6 mb-3"> <label for="apellidoConductor" class="form-label">Apellido <span class="text-danger">*</span></label> <input type="text" class="form-control" id="apellidoConductor" name="apellido" required> </div>
                        </div>
                        <div class="row">
                             <div class="col-md-6 mb-3"> <label for="dniConductor" class="form-label">DNI <span class="text-danger">*</span></label> <input type="text" class="form-control" id="dniConductor" name="dni" required pattern="[0-9]{8}" title="DNI debe contener 8 dígitos"> <div class="invalid-feedback">Por favor ingresa un DNI válido de 8 dígitos.</div> </div>
                             <!-- Campo Licencia Añadido -->
                            <div class="col-md-6 mb-3">
                                <label for="licenciaConductor" class="form-label">Licencia Conducir</label>
                                <input type="text" class="form-control" id="licenciaConductor" name="licencia_conducir" placeholder="Ej: Q12345678">
                            </div>
                        </div>
                         <div class="row">
                             <div class="col-md-6 mb-3"> <label for="telefonoConductor" class="form-label">Nº Teléfono</label> <input type="tel" class="form-control" id="telefonoConductor" name="telefono" placeholder="Ej: +51 987654321"> </div>
                             <div class="col-md-6 mb-3"> <label for="direccionConductor" class="form-label">Dirección</label> <input type="text" class="form-control" id="direccionConductor" name="direccion"> </div>
                         </div>
                         <div class="row">
                             <div class="col-md-6 mb-3"> <label for="provinciaConductor" class="form-label">Provincia</label> <input type="text" class="form-control" id="provinciaConductor" name="provincia"> </div>
                             <div class="col-md-6 mb-3"> <label for="distritoConductor" class="form-label">Distrito</label> <input type="text" class="form-control" id="distritoConductor" name="distrito"> </div>
                         </div>
                        <div class="mb-3">
                            <label for="dniImagenConductor" class="form-label">Adjuntar Imagen DNI</label> <input class="form-control" type="file" id="dniImagenConductor" name="dni_imagen" accept="image/jpeg, image/png, image/gif"> <div class="form-text">Sube una imagen clara del DNI (JPG, PNG, GIF). Tamaño máx: 2MB.</div> <img id="imgPreviewConductor" src="#" alt="Vista previa DNI Conductor" class="img-preview img-thumbnail"/>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                    <button type="submit" class="btn btn-primary" form="formConductor">Guardar Cambios</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
     <!-- Ruta JS verificada -->
    <script src="../js/script.js"></script>

    <!-- Script específico para Conductores -->
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // --- Selectores (Añadir selector licencia) ---
            const modalConductorElement = document.getElementById('modalConductor');
            const modalConductor = modalConductorElement ? new bootstrap.Modal(modalConductorElement) : null;
            const formConductor = document.getElementById('formConductor');
            const modalTitleCond = document.getElementById('modalConductorLabel');
            const conductorIdInput = document.getElementById('conductor_id');
            const accionInputCond = document.getElementById('accionConductor');
            const imgPreviewCond = document.getElementById('imgPreviewConductor');
            const dniImagenInputCond = document.getElementById('dniImagenConductor');
            const tablaBodyCond = document.getElementById('tablaConductoresBody');
            const searchInputCond = document.getElementById('searchConductorInput');
            const searchButtonCond = document.getElementById('searchConductorButton');
            const noResultsRowCond = document.getElementById('noResultsConductorRow');
            const noDataRowCond = document.getElementById('noDataConductorRow');
            const telefonoInputCond = document.getElementById('telefonoConductor');
            const licenciaInputCond = document.getElementById('licenciaConductor'); // NUEVO SELECTOR

            // --- Lógica del Modal ---
            document.getElementById('btnAgregarConductor')?.addEventListener('click', function() {
                 if (!modalConductor || !formConductor) return;
                 modalTitleCond.textContent = 'Agregar Conductor'; formConductor.reset(); conductorIdInput.value = '0'; accionInputCond.value = 'agregar'; imgPreviewCond.style.display = 'none'; imgPreviewCond.src = '#'; formConductor.classList.remove('was-validated');
            });
            tablaBodyCond?.addEventListener('click', function(event) { // Añadir ?
                const targetEdit = event.target.closest('.btnEditarConductor');
                const targetDelete = event.target.closest('.btnEliminarConductor');

                if (targetEdit && modalConductor && formConductor) {
                    modalTitleCond.textContent = 'Editar Conductor';
                    conductorIdInput.value = targetEdit.dataset.id;
                    accionInputCond.value = 'editar';
                    document.getElementById('nombreConductor').value = targetEdit.dataset.nombre;
                    document.getElementById('apellidoConductor').value = targetEdit.dataset.apellido;
                    document.getElementById('dniConductor').value = targetEdit.dataset.dni;
                    document.getElementById('direccionConductor').value = targetEdit.dataset.direccion;
                    document.getElementById('provinciaConductor').value = targetEdit.dataset.provincia;
                    document.getElementById('distritoConductor').value = targetEdit.dataset.distrito;
                    telefonoInputCond.value = targetEdit.dataset.telefono;
                    licenciaInputCond.value = targetEdit.dataset.licencia; // MODIFICADO: Cargar licencia
                    imgPreviewCond.style.display = 'none'; imgPreviewCond.src = '#';
                    if(dniImagenInputCond) dniImagenInputCond.value = '';
                    formConductor.classList.remove('was-validated');
                    // No se abre el modal aquí, se hace con data-bs-toggle
                } else if (targetDelete) {
                     const conductorId = targetDelete.dataset.id; const conductorNombre = targetDelete.dataset.nombre; if (confirm(`¿Estás seguro de que deseas eliminar al conductor "${conductorNombre}" (ID: ${conductorId})? Esta acción no se puede deshacer.`)) { const formDelete = document.createElement('form'); formDelete.method = 'POST'; formDelete.action = '../controllers/conductor_controller.php'; const idInput = document.createElement('input'); idInput.type = 'hidden'; idInput.name = 'conductor_id'; idInput.value = conductorId; formDelete.appendChild(idInput); const actionInput = document.createElement('input'); actionInput.type = 'hidden'; actionInput.name = 'accion'; actionInput.value = 'eliminar'; formDelete.appendChild(actionInput); document.body.appendChild(formDelete); formDelete.submit(); }
                }
            });
             dniImagenInputCond?.addEventListener('change', function(event) { /* ... (Preview igual, usa imgPreviewCond) ... */ if(!imgPreviewCond) return; const file = event.target.files[0]; if (file && file.type.startsWith('image/')) { const reader = new FileReader(); reader.onload = function(e) { imgPreviewCond.src = e.target.result; imgPreviewCond.style.display = 'block'; }; reader.readAsDataURL(file); } else { imgPreviewCond.src = '#'; imgPreviewCond.style.display = 'none'; } });


            // --- Lógica de Búsqueda ---
             function performConductorSearch() { /* ... (Sin cambios, busca por nombre/apellido/dni) ... */
                if (!searchInputCond || !tablaBodyCond || !noResultsRowCond) return; const searchTerm = searchInputCond.value.toLowerCase().trim(); const rows = tablaBodyCond.querySelectorAll('tr:not(#noResultsConductorRow):not(#noDataConductorRow)'); let resultsFound = false;
                 rows.forEach(row => { const nombre = row.cells[1]?.textContent.toLowerCase() || ''; const apellido = row.cells[2]?.textContent.toLowerCase() || ''; const dni = row.cells[3]?.textContent.toLowerCase() || ''; if (nombre.includes(searchTerm) || apellido.includes(searchTerm) || dni.includes(searchTerm)) { row.style.display = ''; resultsFound = true; } else { row.style.display = 'none'; } });
                 noResultsRowCond.style.display = resultsFound ? 'none' : ''; if (noDataRowCond) { noDataRowCond.style.display = (searchTerm === '' && <?php echo empty($conductores) ? 'true' : 'false'; ?>) ? '' : 'none'; } if (searchTerm === '') { rows.forEach(row => row.style.display = ''); noResultsRowCond.style.display = 'none'; }
             }
             searchButtonCond?.addEventListener('click', performConductorSearch); // Añadir ?
             searchInputCond?.addEventListener('keypress', function(event) { if (event.key === 'Enter') { event.preventDefault(); performConductorSearch(); } }); // Añadir ?

        }); // Fin DOMContentLoaded
    </script>

</body>
</html>