<?php
// 1. Iniciar sesión y verificar login
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) { header('Location: ../index.php?error=not_logged_in'); exit; }

// 2. Incluir conexión BD
require_once '../config/db.php'; // Salir de views a config/

// --- Lógica de Roles (Para Sidebar y Permisos) ---
$user_role = isset($_SESSION['user_role']) ? $_SESSION['user_role'] : 'usuario';
$current_user_id = $_SESSION['user_id'];
// -------------------------------------------------

// 3. Obtener vehículos (con JOINs para nombres y NUEVO campo tablero)
$vehiculos = [];
$error_db = null;
try {
    if (!isset($pdo)) { throw new Exception("Error: La conexión a la base de datos (PDO) no está definida."); }
    // SELECCIONAR el nuevo campo 'tablero'
    $sql = "SELECT v.id, v.placa, v.color, v.marca, v.modelo, v.anio_modelo, v.tablero, -- << AÑADIDO v.tablero
                   v.anotacion1, v.anotacion2,
                   p.id as propietario_id, CONCAT(p.nombre, ' ', p.apellido) as propietario_nombre,
                   c.id as conductor_id, CONCAT(c.nombre, ' ', c.apellido) as conductor_nombre
            FROM vehiculos v
            JOIN propietarios p ON v.propietario_id = p.id
            LEFT JOIN conductores c ON v.conductor_id = c.id
            ORDER BY v.placa"; // Ordenar por placa por defecto
    $stmt = $pdo->query($sql);
    $vehiculos = $stmt->fetchAll();
} catch (PDOException $e) {
    error_log("Error PDO al obtener vehículos: " . $e->getMessage());
    $error_db = "No se pudieron cargar los vehículos (Error DB: " . $e->getCode() . ")";
} catch (Exception $e) {
    error_log("Error general al obtener vehículos: " . $e->getMessage());
    $error_db = $e->getMessage();
}

// 4. Datos usuario navbar
$username = isset($_SESSION['username']) ? htmlspecialchars($_SESSION['username']) : 'Usuario';
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Vehículos - SysVehiculos</title>
    <!-- CSS / Font Awesome -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    
    <!-- === FAVICON === -->
    <!-- Ruta relativa desde la raíz a la carpeta img/ -->
    <link rel="icon" href="img/favicon.ico" type="image/x-icon">
    <link rel="shortcut icon" href="img/favicon.ico" type="image/x-icon">
    <!-- Opcional: Si tienes un apple-touch-icon.png en /img/ -->
    <!-- <link rel="apple-touch-icon" href="img/apple-touch-icon.png"> -->
    <!-- ============= -->

    <!-- Ruta CSS corregida -->
    <link rel="stylesheet" href="../css/style.css">
    <style>
        /* Estilos AJAX search results y filas especiales */
        .search-results { position: absolute; background-color: var(--panel-bg-light); border: 1px solid var(--border-color-light); border-top: none; max-height: 200px; overflow-y: auto; width: calc(100% - 2px); z-index: 1050; display: none; border-radius: 0 0 0.375rem 0.375rem; box-shadow: var(--shadow-light); margin-top: -1px; }
         body.dark-mode .search-results { background-color: var(--panel-bg-dark); border-color: var(--border-color-dark); }
        .search-results .list-group-item { cursor: pointer; padding: 0.5rem 1rem; font-size: 0.9rem; background-color: transparent !important; color: var(--text-light); }
         body.dark-mode .search-results .list-group-item { color: var(--text-dark); border-bottom: 1px solid var(--border-color-dark) !important; }
         .search-results .list-group-item:last-child { border-bottom: none !important; }
        .search-results .list-group-item:hover { background-color: rgba(0, 0, 0, 0.05) !important; }
         body.dark-mode .search-results .list-group-item:hover { background-color: rgba(255, 255, 255, 0.07) !important; }
        .search-results .result-details { font-size: 0.8rem; color: var(--secondary-color); }
         body.dark-mode .search-results .result-details { color: var(--text-muted-dark); }
         .position-relative { position: relative; }
        #noResultsRowVehiculo td, #noDataVehiculoRow td { font-style: italic; color: var(--secondary-color); }
        body.dark-mode #noResultsRowVehiculo td, body.dark-mode #noDataVehiculoRow td { color: var(--text-muted-dark); }
    </style>
</head>
<body class="dashboard-page">
    <div class="d-flex" id="wrapper">

        <!-- Sidebar (Incluida) -->
        <?php require_once '../includes/sidebar.php'; ?>

        <!-- Page Content -->
        <div id="page-content-wrapper">
            <nav class="navbar navbar-expand-lg navbar-light bg-light border-bottom">
                 <!-- ... (Navbar sin cambios) ... -->
                 <div class="container-fluid">
                    <button class="btn btn-primary btn-sm" id="sidebarToggle"><i class="fas fa-align-left"></i></button>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent"> <span class="navbar-toggler-icon"></span> </button>
                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav ms-auto mt-2 mt-lg-0">
                            <li class="nav-item me-2"> <button class="btn btn-sm theme-toggle-btn-nav"> <i class="fas fa-moon"></i> <span class="d-none d-sm-inline">Tema</span> </button> </li>
                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle" id="navbarDropdown" href="#" role="button" data-bs-toggle="dropdown"> <i class="fas fa-user me-1"></i> <?php echo $username; ?> </a>
                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                                    <a class="dropdown-item" href="#!">Mi Perfil</a> <a class="dropdown-item" href="#!">Configuración</a>
                                    <div class="dropdown-divider"></div> <a class="dropdown-item text-danger" href="../logout.php">Cerrar Sesión</a>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </nav>

            <!-- Contenido Principal de Vehículos -->
            <div class="container-fluid px-4">
                <h1 class="mt-4">Gestión de Vehículos</h1>
                <p>Administra los vehículos registrados.</p>

                 <div class="d-flex justify-content-between align-items-center mb-3">
                    <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#modalVehiculo" id="btnAgregarVehiculo"> <i class="fas fa-plus me-1"></i> Agregar Vehículo </button>
                 </div>

                 <!-- Buscador Vehículos -->
                 <div class="row mb-3">
                    <div class="col-md-6">
                        <div class="input-group">
                            <input type="search" id="searchVehiculoInput" class="form-control" placeholder="Buscar por Placa, Marca o Modelo..." aria-label="Buscar Vehículo">
                            <button class="btn btn-outline-secondary" type="button" id="searchVehiculoButton"> <i class="fas fa-search"></i> Buscar </button>
                        </div>
                    </div>
                 </div>

                 <!-- Mensajes -->
                 <?php if ($error_db): ?><div class="alert alert-danger"><?php echo htmlspecialchars($error_db); ?></div><?php endif; ?>
                 <?php if (isset($_SESSION['form_success'])): ?><div class="alert alert-success alert-dismissible fade show" role="alert"><?php echo htmlspecialchars($_SESSION['form_success']); ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div><?php unset($_SESSION['form_success']); ?><?php endif; ?>
                 <?php if (isset($_SESSION['form_error'])): ?><div class="alert alert-danger alert-dismissible fade show" role="alert"><?php echo htmlspecialchars($_SESSION['form_error']); ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div><?php unset($_SESSION['form_error']); ?><?php endif; ?>

                 <!-- Tabla de Vehículos -->
                 <div class="card mb-4">
                    <div class="card-header"> <i class="fas fa-table me-1"></i> Listado de Vehículos </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover table-bordered" id="tablaVehiculos">
                                <thead class="table-dark">
                                    <tr>
                                        <!-- Columna Tablero añadida -->
                                        <th>#</th><th>Placa</th><th>Marca</th><th>Modelo</th><th>Año</th><th>Tablero</th>
                                        <th>Color</th><th>Propietario</th><th>Conductor</th><th>Acciones</th>
                                    </tr>
                                </thead>
                                <tbody id="tablaVehiculosBody">
                                    <?php if (!$error_db && empty($vehiculos)): ?>
                                        <!-- Colspan aumentado a 10 -->
                                        <tr id="noDataVehiculoRow"> <td colspan="10" class="text-center">No hay vehículos registrados.</td> </tr>
                                    <?php elseif (!$error_db): ?>
                                        <?php $countVeh = 1; ?>
                                        <?php foreach ($vehiculos as $veh): ?>
                                            <tr>
                                                <td><?php echo $countVeh++; ?></td>
                                                <td><?php echo htmlspecialchars($veh['placa']); ?></td>
                                                <td><?php echo htmlspecialchars($veh['marca'] ?? '-'); ?></td>
                                                <td><?php echo htmlspecialchars($veh['modelo'] ?? '-'); ?></td>
                                                <td><?php echo htmlspecialchars($veh['anio_modelo'] ?? '-'); ?></td>
                                                <!-- Mostrar valor de Tablero -->
                                                <td><?php echo htmlspecialchars($veh['tablero'] ?? '-'); ?></td>
                                                <td><?php echo htmlspecialchars($veh['color'] ?? '-'); ?></td>
                                                <td><?php echo htmlspecialchars($veh['propietario_nombre'] ?? 'N/A'); ?></td>
                                                <td><?php echo htmlspecialchars($veh['conductor_nombre'] ?? 'No asignado'); ?></td>
                                                <td>
                                                    <!-- BOTÓN EDITAR CORREGIDO: Eliminado comentario interno -->
                                                    <button type="button" class="btn btn-sm btn-warning btnEditarVehiculo"
                                                            data-bs-toggle="modal" data-bs-target="#modalVehiculo"
                                                            data-id="<?php echo $veh['id']; ?>"
                                                            data-placa="<?php echo htmlspecialchars($veh['placa']); ?>"
                                                            data-color="<?php echo htmlspecialchars($veh['color'] ?? ''); ?>"
                                                            data-marca="<?php echo htmlspecialchars($veh['marca'] ?? ''); ?>"
                                                            data-modelo="<?php echo htmlspecialchars($veh['modelo'] ?? ''); ?>"
                                                            data-anio="<?php echo htmlspecialchars($veh['anio_modelo'] ?? ''); ?>"
                                                            data-tablero="<?php echo htmlspecialchars($veh['tablero'] ?? ''); ?>"
                                                            data-anotacion1="<?php echo htmlspecialchars($veh['anotacion1'] ?? ''); ?>"
                                                            data-anotacion2="<?php echo htmlspecialchars($veh['anotacion2'] ?? ''); ?>"
                                                            data-propietario-id="<?php echo $veh['propietario_id']; ?>"
                                                            data-propietario-nombre="<?php echo htmlspecialchars($veh['propietario_nombre'] ?? ''); ?>"
                                                            data-conductor-id="<?php echo $veh['conductor_id'] ?? ''; ?>"
                                                            data-conductor-nombre="<?php echo htmlspecialchars($veh['conductor_nombre'] ?? ''); ?>"
                                                            title="Editar Vehículo"> <i class="fas fa-edit"></i> </button>
                                                    <?php if ($user_role === 'administrador'): ?>
                                                        <button type="button" class="btn btn-sm btn-danger btnEliminarVehiculo"
                                                                data-id="<?php echo $veh['id']; ?>"
                                                                data-placa="<?php echo htmlspecialchars($veh['placa']); ?>"
                                                                title="Eliminar Vehículo"> <i class="fas fa-trash-alt"></i> </button>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                    <!-- Colspan aumentado a 10 -->
                                    <tr id="noResultsRowVehiculo" style="display: none;"> <td colspan="10" class="text-center text-muted">No se encontraron vehículos para su búsqueda.</td> </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div> <!-- /container-fluid -->
        </div> <!-- /#page-content-wrapper -->
    </div> <!-- /#wrapper -->

    <!-- Modal para Agregar/Editar Vehículo -->
    <div class="modal fade" id="modalVehiculo" tabindex="-1" aria-labelledby="modalVehiculoLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalVehiculoLabel">Agregar Vehículo</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <!-- Ruta action verificada -->
                    <form id="formVehiculo" method="POST" action="../controllers/vehiculo_controller.php" novalidate> <!-- Añadido novalidate para validación JS -->
                        <input type="hidden" name="vehiculo_id" id="vehiculo_id" value="0">
                        <input type="hidden" name="accion" id="accionVehiculo" value="agregar">

                        <div class="row">
                            <div class="col-md-6 mb-3"> <label for="placa" class="form-label">Nº Placa <span class="text-danger">*</span></label> <input type="text" class="form-control" id="placa" name="placa" required maxlength="10" style="text-transform:uppercase"> </div>
                            <div class="col-md-6 mb-3"> <label for="color" class="form-label">Color</label> <input type="text" class="form-control" id="color" name="color"> </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3"> <label for="marca" class="form-label">Marca</label> <input type="text" class="form-control" id="marca" name="marca"> </div>
                             <div class="col-md-6 mb-3"> <label for="modelo" class="form-label">Modelo</label> <input type="text" class="form-control" id="modelo" name="modelo"> </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3"> <label for="anio_modelo" class="form-label">Año Modelo</label> <input type="number" class="form-control" id="anio_modelo" name="anio_modelo" min="1900" max="<?php echo date('Y') + 1; ?>"> </div>
                            <!-- NUEVO CAMPO TABLERO -->
                            <div class="col-md-6 mb-3">
                                <label for="tablero" class="form-label">Tablero</label>
                                <input type="text" class="form-control" id="tablero" name="tablero" maxlength="100">
                            </div>
                        </div>
                        <div class="mb-3"> <label for="anotacion1" class="form-label">Anotaciones 1</label> <textarea class="form-control" id="anotacion1" name="anotacion1" rows="2" maxlength="60"></textarea> <div class="form-text">Máximo 60 caracteres.</div> </div>
                         <div class="mb-3"> <label for="anotacion2" class="form-label">Anotaciones 2</label> <textarea class="form-control" id="anotacion2" name="anotacion2" rows="2" maxlength="60"></textarea> <div class="form-text">Máximo 60 caracteres.</div> </div>
                        <hr> <h6>Asignación</h6>
                        <!-- Buscador Propietario -->
                        <div class="mb-3 position-relative">
                            <label for="propietarioSearch" class="form-label">Propietario <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="propietarioSearch" placeholder="Buscar por nombre, apellido o DNI..." autocomplete="off">
                            <input type="hidden" name="propietario_id" id="propietarioIdSelected" required>
                            <div id="propietarioResults" class="list-group search-results"></div>
                            <div class="invalid-feedback">Debe seleccionar un propietario.</div>
                            <div id="propietarioSelectedInfo" class="form-text mt-1 fw-bold"></div> <!-- Texto seleccionado en negrita -->
                        </div>
                         <!-- Buscador Conductor -->
                        <div class="mb-3 position-relative">
                            <label for="conductorSearch" class="form-label">Conductor (Opcional)</label>
                             <div class="input-group"> <!-- Grupo para botón limpiar -->
                                <input type="text" class="form-control" id="conductorSearch" placeholder="Buscar por nombre, apellido o DNI..." autocomplete="off">
                                <button class="btn btn-outline-secondary btn-sm" type="button" id="clearConductorBtn" title="Limpiar Conductor"><i class="fas fa-times"></i></button>
                            </div>
                            <input type="hidden" name="conductor_id" id="conductorIdSelected">
                            <div id="conductorResults" class="list-group search-results"></div>
                             <div id="conductorSelectedInfo" class="form-text mt-1 fw-bold"></div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                    <button type="submit" class="btn btn-primary" form="formVehiculo">Guardar Vehículo</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Ruta JS verificada -->
    <script src="../js/script.js"></script>

    <!-- Script específico para Vehículos -->
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // --- Selectores ---
            const modalVehiculoElement = document.getElementById('modalVehiculo');
            const modalVehiculo = modalVehiculoElement ? new bootstrap.Modal(modalVehiculoElement) : null;
            const formVehiculo = document.getElementById('formVehiculo');
            const modalTitleVeh = document.getElementById('modalVehiculoLabel');
            const vehiculoIdInput = document.getElementById('vehiculo_id');
            const accionInputVeh = document.getElementById('accionVehiculo');
            // Campos Vehículo
            const placaInput = document.getElementById('placa');
            const colorInput = document.getElementById('color');
            const marcaInput = document.getElementById('marca');
            const modeloInput = document.getElementById('modelo');
            const anioInput = document.getElementById('anio_modelo');
            const tableroInput = document.getElementById('tablero'); // <<<--- NUEVO SELECTOR
            const anotacion1Input = document.getElementById('anotacion1');
            const anotacion2Input = document.getElementById('anotacion2');
            // Buscador Propietario
            const propSearchInput = document.getElementById('propietarioSearch');
            const propResultsDiv = document.getElementById('propietarioResults');
            const propIdSelectedInput = document.getElementById('propietarioIdSelected');
            const propSelectedInfo = document.getElementById('propietarioSelectedInfo');
            // Buscador Conductor
            const condSearchInput = document.getElementById('conductorSearch');
            const condResultsDiv = document.getElementById('conductorResults');
            const condIdSelectedInput = document.getElementById('conductorIdSelected');
            const condSelectedInfo = document.getElementById('conductorSelectedInfo');
            const clearConductorBtn = document.getElementById('clearConductorBtn'); // Botón limpiar conductor
            // Tabla y búsqueda Tabla
            const tablaBodyVeh = document.getElementById('tablaVehiculosBody');
            const searchInputVeh = document.getElementById('searchVehiculoInput');
            const searchButtonVeh = document.getElementById('searchVehiculoButton');
            const noResultsRowVeh = document.getElementById('noResultsRowVehiculo');
            const noDataRowVeh = document.getElementById('noDataVehiculoRow');

             // --- Limpiar Modal ---
             function resetModalVehiculo() {
                 if (!formVehiculo) return;
                 modalTitleVeh.textContent = 'Agregar Vehículo';
                 formVehiculo.reset(); // Esto debería limpiar tableroInput también
                 vehiculoIdInput.value = '0';
                 accionInputVeh.value = 'agregar';
                 // Limpiar explícitamente campos de búsqueda y seleccionados
                 propIdSelectedInput.value = ''; condIdSelectedInput.value = '';
                 propSearchInput.value = ''; condSearchInput.value = '';
                 propResultsDiv.innerHTML = ''; condResultsDiv.innerHTML = '';
                 propResultsDiv.style.display = 'none'; condResultsDiv.style.display = 'none';
                 propSelectedInfo.textContent = ''; condSelectedInfo.textContent = '';
                 propSearchInput.classList.remove('is-invalid'); // Limpiar validación prop
                 formVehiculo.classList.remove('was-validated');
             }

            // --- Lógica Modal (Agregar/Editar) ---
            document.getElementById('btnAgregarVehiculo')?.addEventListener('click', resetModalVehiculo);

            tablaBodyVeh?.addEventListener('click', function(event) {
                const targetEdit = event.target.closest('.btnEditarVehiculo');
                if (targetEdit && modalVehiculo && formVehiculo) {
                    resetModalVehiculo(); // Limpia primero
                    modalTitleVeh.textContent = 'Editar Vehículo';
                    vehiculoIdInput.value = targetEdit.dataset.id;
                    accionInputVeh.value = 'editar';
                    placaInput.value = targetEdit.dataset.placa;
                    colorInput.value = targetEdit.dataset.color;
                    marcaInput.value = targetEdit.dataset.marca;
                    modeloInput.value = targetEdit.dataset.modelo;
                    anioInput.value = targetEdit.dataset.anio;
                    tableroInput.value = targetEdit.dataset.tablero; // <<<--- RELLENAR TABLERO
                    anotacion1Input.value = targetEdit.dataset.anotacion1;
                    anotacion2Input.value = targetEdit.dataset.anotacion2;
                    // Rellenar Propietario
                    propIdSelectedInput.value = targetEdit.dataset.propietarioId;
                    propSearchInput.value = targetEdit.dataset.propietarioNombre || '';
                    propSelectedInfo.textContent = targetEdit.dataset.propietarioId ? `Seleccionado: ${targetEdit.dataset.propietarioNombre} (ID: ${targetEdit.dataset.propietarioId})` : '';
                    // Rellenar Conductor
                    condIdSelectedInput.value = targetEdit.dataset.conductorId || '';
                    condSearchInput.value = targetEdit.dataset.conductorNombre || '';
                    condSelectedInfo.textContent = targetEdit.dataset.conductorId ? `Seleccionado: ${targetEdit.dataset.conductorNombre} (ID: ${targetEdit.dataset.conductorId})` : '';
                }
            });

             // --- Lógica Buscadores AJAX (Propietario y Conductor) ---
            function setupAjaxSearch(searchInput, resultsDiv, idInput, infoDiv, searchUrl, isRequired) {
                let debounceTimer;
                searchInput.addEventListener('input', function() {
                    const inputElement = this; // Guardar referencia al input
                    clearTimeout(debounceTimer);
                    const term = this.value.trim();
                    resultsDiv.innerHTML = '';
                    resultsDiv.style.display = 'none';
                    // Limpiar ID si se borra el texto o si se busca sin seleccionar (excepto al cargar edit)
                    if (inputElement.value === '') { idInput.value = ''; }
                    // Actualizar info basado en si hay ID seleccionado
                    infoDiv.textContent = idInput.value ? `Seleccionado: ${inputElement.value} (ID: ${idInput.value})` : '';
                    inputElement.classList.remove('is-invalid'); // Limpiar validación al escribir

                    if (term.length < 2) return; // Mínimo 2 caracteres para buscar

                    debounceTimer = setTimeout(() => {
                        fetch(`${searchUrl}?term=${encodeURIComponent(term)}`)
                            .then(response => response.ok ? response.json() : Promise.reject('Error de red'))
                            .then(data => {
                                resultsDiv.innerHTML = ''; // Limpiar de nuevo
                                if (data && data.length > 0 && !data.error) {
                                    data.forEach(item => {
                                        const div = document.createElement('div');
                                        div.classList.add('list-group-item', 'list-group-item-action');
                                        div.dataset.id = item.id;
                                        const nombreCompleto = `${item.nombre || ''} ${item.apellido || ''}`.trim();
                                        div.dataset.nombreCompleto = nombreCompleto;
                                        div.innerHTML = `<strong>${nombreCompleto}</strong> <div class="result-details">DNI: ${item.dni || 'N/A'} | Tel: ${item.telefono || 'N/A'}</div>`;
                                        div.addEventListener('click', function() {
                                            inputElement.value = this.dataset.nombreCompleto; // Poner nombre en input
                                            idInput.value = this.dataset.id; // Poner ID en input oculto
                                            infoDiv.textContent = `Seleccionado: ${this.dataset.nombreCompleto} (ID: ${this.dataset.id})`; // Mostrar info
                                            resultsDiv.style.display = 'none'; // Ocultar resultados
                                            inputElement.classList.remove('is-invalid'); // Quitar error si había
                                            // Para conductor, si se selecciona uno, no limpiar
                                        });
                                        resultsDiv.appendChild(div);
                                    });
                                } else {
                                    resultsDiv.innerHTML = `<div class="list-group-item text-muted">${data.error || 'No se encontraron coincidencias.'}</div>`;
                                }
                                resultsDiv.style.display = 'block';
                            })
                            .catch(error => {
                                console.error('Error en búsqueda AJAX:', error);
                                resultsDiv.innerHTML = `<div class="list-group-item text-danger">Error al buscar.</div>`;
                                resultsDiv.style.display = 'block';
                            });
                    }, 350); // Debounce
                });
                 // Ocultar resultados si se hace clic fuera
                 document.addEventListener('click', function(event) {
                     if (!searchInput.contains(event.target) && !resultsDiv.contains(event.target)) {
                         resultsDiv.style.display = 'none';
                     }
                 });
            }
            // Configurar búsqueda para Propietario (ruta API corregida)
            setupAjaxSearch(propSearchInput, propResultsDiv, propIdSelectedInput, propSelectedInfo, '../api/search_propietario.php', true);
            // Configurar búsqueda para Conductor (ruta API corregida)
            setupAjaxSearch(condSearchInput, condResultsDiv, condIdSelectedInput, condSelectedInfo, '../api/search_conductor.php', false);

            // --- Botón Limpiar Conductor ---
            clearConductorBtn?.addEventListener('click', function() {
                condSearchInput.value = '';
                condIdSelectedInput.value = '';
                condSelectedInfo.textContent = '';
                condResultsDiv.innerHTML = '';
                condResultsDiv.style.display = 'none';
            });

             // --- Validación Submit Modal ---
             formVehiculo?.addEventListener('submit', function (event) {
                 // Validar que se haya seleccionado un propietario
                 if (!propIdSelectedInput.value) {
                     propSearchInput.classList.add('is-invalid');
                 } else {
                     propSearchInput.classList.remove('is-invalid');
                 }

                 if (!formVehiculo.checkValidity() || !propIdSelectedInput.value) {
                   event.preventDefault();
                   event.stopPropagation();
                 }
                 formVehiculo.classList.add('was-validated');
             }, false);

            // --- Lógica Eliminar Vehículo ---
            tablaBodyVeh?.addEventListener('click', function(event) {
                 const targetDelete = event.target.closest('.btnEliminarVehiculo');
                 if (targetDelete) { const vehiculoId = targetDelete.dataset.id; const vehiculoPlaca = targetDelete.dataset.placa; if (confirm(`¿Estás seguro de que deseas eliminar el vehículo con placa "${vehiculoPlaca}" (ID: ${vehiculoId})?`)) { const formDelete = document.createElement('form'); formDelete.method = 'POST'; formDelete.action = '../controllers/vehiculo_controller.php'; const idInput = document.createElement('input'); idInput.type = 'hidden'; idInput.name = 'vehiculo_id'; idInput.value = vehiculoId; formDelete.appendChild(idInput); const actionInput = document.createElement('input'); actionInput.type = 'hidden'; actionInput.name = 'accion'; actionInput.value = 'eliminar'; formDelete.appendChild(actionInput); document.body.appendChild(formDelete); formDelete.submit(); } }
            });

            // --- Lógica Búsqueda Tabla Vehículos ---
             function performVehiculoSearch() {
                 if (!searchInputVeh || !tablaBodyVeh || !noResultsRowVeh) return; const searchTerm = searchInputVeh.value.toLowerCase().trim(); const rows = tablaBodyVeh.querySelectorAll('tr:not(#noResultsRowVehiculo):not(#noDataVehiculoRow)'); let resultsFound = false;
                 rows.forEach(row => { const placa = row.cells[1]?.textContent.toLowerCase() || ''; const marca = row.cells[2]?.textContent.toLowerCase() || ''; const modelo = row.cells[3]?.textContent.toLowerCase() || ''; if (placa.includes(searchTerm) || marca.includes(searchTerm) || modelo.includes(searchTerm)) { row.style.display = ''; resultsFound = true; } else { row.style.display = 'none'; } });
                 noResultsRowVeh.style.display = resultsFound ? 'none' : ''; if (noDataRowVeh) { noDataRowVeh.style.display = (searchTerm === '' && <?php echo empty($vehiculos) ? 'true' : 'false'; ?>) ? '' : 'none'; } if (searchTerm === '') { rows.forEach(row => row.style.display = ''); noResultsRowVeh.style.display = 'none'; }
             }
             searchButtonVeh?.addEventListener('click', performVehiculoSearch);
             searchInputVeh?.addEventListener('keypress', function(event) { if (event.key === 'Enter') { event.preventDefault(); performVehiculoSearch(); } });

        }); // Fin DOMContentLoaded
    </script>

</body>
</html>