<?php
/**
 * Clase para manejar la conexión a la base de datos usando PDO.
 */
class Database {
    private static $host      = DB_HOST;
    private static $dbName    = DB_NAME;
    private static $username  = DB_USER;
    private static $password  = DB_PASS;
    private static $charset   = DB_CHARSET;

    private static $cont  = null; // Contenedor para la conexión

    public function __construct() {
        die('La función Init no está permitida.'); // Prevenir instanciación directa
    }

    public static function connect() {
        // Una sola conexión para toda la aplicación (Patrón Singleton básico)
        if (null == self::$cont) {
            try {
                $dsn = "mysql:host=" . self::$host . ";dbname=" . self::$dbName . ";charset=" . self::$charset;
                self::$cont = new PDO($dsn, self::$username, self::$password);
                // Configurar PDO para lanzar excepciones en caso de error
                self::$cont->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                // Desactivar emulación de preparaciones para mayor seguridad (si la versión de MySQL/MariaDB lo soporta bien)
                self::$cont->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
            } catch(PDOException $e) {
                // En producción, no mostrar detalles del error al usuario final
                // Loggear el error en un archivo o sistema de monitoreo
                 error_log("Error de conexión a BD: " . $e->getMessage());
                die("Error conectando a la base de datos. Por favor, inténtelo más tarde.");
            }
        }
        return self::$cont;
    }

    public static function disconnect() {
        self::$cont = null;
    }
}
?>