<?php ob_start(); ?>
<?php
// --- INICIO PHP (sin cambios en la lógica) ---
require_once 'config.php';
require_once 'includes/database.php';
session_start();
if (!isset($_SESSION['user_id'])) { /* ... protección ... */ header("Location: login.php"); exit; }
// --- Routing (sin cambios) ---
$allowed_pages = ['home', 'candidatos', 'centros_votacion', 'registro_votos', 'reporte_votos', 'usuarios'];
$page = 'home';
if (isset($_GET['page']) && in_array($_GET['page'], $allowed_pages)) { /* ... protección admin ... */ $page = $_GET['page']; }
$view_file = "views/" . $page . ".php";
if ($page === 'home') { $view_file = "views/dashboard_home.php"; }
if (!file_exists($view_file)) { /* ... fallback a home ... */ }
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Votos - <?php echo ucfirst(str_replace('_', ' ', $page)); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link rel="stylesheet" href="assets/css/style.css"> <!-- Enlace CSS -->
    <script> (function() { const theme = localStorage.getItem('theme') || 'light'; document.documentElement.setAttribute('data-bs-theme', theme); })(); </script>
</head>
<body>

    <!-- Barra Superior (Navbar) -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark fixed-top shadow-sm">
         <!-- ... (Contenido de la navbar sin cambios) ... -->
         <div class="container-fluid">
            <a class="navbar-brand" href="index.php?page=home"><i class="fas fa-vote-yea fa-lg me-2"></i> VotosSys</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent"><span class="navbar-toggler-icon"></span></button>
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav ms-auto mb-2 mb-lg-0 align-items-center">
                     <li class="nav-item me-3"> <div class="theme-switch-wrapper nav-link p-0"> <i class="fas fa-sun"></i> <label class="theme-switch" for="themeSwitch"> <input type="checkbox" id="themeSwitch"> <span class="slider round"></span> </label> <i class="fas fa-moon"></i> </div> </li>
                     <li class="nav-item dropdown"> <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown"><i class="fas fa-user-circle me-1"></i> <?php echo htmlspecialchars($_SESSION['username']); ?></a> <ul class="dropdown-menu dropdown-menu-end"> <li><a class="dropdown-item" href="#">Mi Perfil</a></li> <li><a class="dropdown-item" href="#">Configuración</a></li> <li><hr class="dropdown-divider"></li> <li><a class="dropdown-item text-danger" href="logout.php">Salir</a></li> </ul> </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Wrapper Principal para Sidebar y Contenido -->
    <div class="main-wrapper">

        <!-- Sidebar -->
        <nav id="sidebar">
            <!-- Navegación Principal (Scrollable) -->
            <ul class="nav flex-column nav-sidebar pt-3">
                <!-- ... (Enlaces del sidebar sin cambios) ... -->
                 <li class="nav-item"> <a class="nav-link <?php echo ($page === 'home') ? 'active' : ''; ?>" href="index.php?page=home"><i class="fas fa-tachometer-alt fa-fw"></i> Dashboard</a></li>
                 <li class="nav-item"> <a class="nav-link <?php echo ($page === 'candidatos') ? 'active' : ''; ?>" href="index.php?page=candidatos"><i class="fas fa-users fa-fw"></i> Candidatos</a></li>
                 <li class="nav-item"> <a class="nav-link <?php echo ($page === 'centros_votacion') ? 'active' : ''; ?>" href="index.php?page=centros_votacion"><i class="fas fa-map-marker-alt fa-fw"></i> Centros/Mesas</a></li>
                 <li class="nav-item"> <a class="nav-link <?php echo ($page === 'registro_votos') ? 'active' : ''; ?>" href="index.php?page=registro_votos"><i class="fas fa-edit fa-fw"></i> Registro de Votos</a></li>
                 <li class="nav-item"> <a class="nav-link <?php echo ($page === 'reporte_votos') ? 'active' : ''; ?>" href="index.php?page=reporte_votos"><i class="fas fa-chart-bar fa-fw"></i> Reporte de Votos</a></li>
                 <?php if (isset($_SESSION['role']) && $_SESSION['role'] === 'administrador'): ?>
                    <li class="nav-item mt-2"> <small class="text-muted px-3 text-uppercase">Administración</small><hr class="mx-3 my-1" style="border-top: 1px solid #495057;"></li>
                    <li class="nav-item"><a class="nav-link <?php echo ($page === 'usuarios') ? 'active' : ''; ?>" href="index.php?page=usuarios"><i class="fas fa-user-cog fa-fw"></i> Gestión Usuarios</a></li>
                 <?php endif; ?>
            </ul>
        </nav>

        <!-- Área de Contenido Principal -->
        <main id="content">
            <?php
            $pdo = null;
            try {
                $pdo = Database::connect();
                include($view_file);
            } catch (Exception $e) { /* ... manejo de error ... */ }
            finally { if ($pdo) { Database::disconnect(); } }
            ?>
        </main>

    </div> <!-- Fin .main-wrapper -->

    <!-- Modal -->
    <div class="modal fade" id="confirmDeleteModal" tabindex="-1"> <!-- ... (Contenido del modal) ... --> </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // --- Script para Modal ---
        const confirmDeleteModal = document.getElementById('confirmDeleteModal');
        if (confirmDeleteModal) { /* ... (código modal igual) ... */ }

        // --- Script para Tema Oscuro/Claro ---
        const themeSwitch = document.getElementById('themeSwitch');
        const htmlElement = document.documentElement;
        function applyTheme(theme) { htmlElement.setAttribute('data-bs-theme', theme); localStorage.setItem('theme', theme); if (themeSwitch) { themeSwitch.checked = (theme === 'dark'); } }
        const currentTheme = localStorage.getItem('theme') || 'light';
        if (themeSwitch) { themeSwitch.checked = (currentTheme === 'dark'); }
        if (themeSwitch) { themeSwitch.addEventListener('change', function() { applyTheme(this.checked ? 'dark' : 'light'); }); }
    </script>

</body>
</html>
<?php ob_end_flush(); ?>